#ifndef __C_NETWORKLAYER_H
#define __C_NETWORKLAYER_H

#define WIN32_LEAN_AND_MEAN

#include "Interfaces/cLayer.h"
#include "Interfaces/cCallback.h"
#include "cIPEndpoint.h"
#include "cNetworkLayerParam.h"
#include <winsock2.h>

class cProtocolStack;
class cMsgBuffer;
class cRegisterList;

#define MAX_MCAST_INTERFACES	4

/*
 * cNetworkLayer.h
 *
 * Standard network layer.
 */
class cNetworkLayer : public cLayer, public cDeliver, public cCallback
{

  public:

	/* -- Callback Methods -- */
	void Callback(HANDLE eventHandle, void* param);

	/* --Deliver Methods-- */
	bool Deliver(cEndpoint* sender, cMsgBuffer* buffer, int messageType);

	// Initialization
	bool Init(cLayer* layerBelow, cParam* param);
	bool Cleanup();

	// Sending of messages.
	bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType);

	bool Schedule() { return true; } //gInfo("Network layer scheduled.", __LINE__, __FILE__); return true; }

	// Callback Registration/Unregisteration
	bool		RegisterDeliverCallback(cHandle* handle, cDeliver* callback);
	bool		UnregisterDeliverCallback(cHandle handle);
	bool		RegisterViewCallback(cHandle* handle, cView* callback);
	bool		UnregisterViewCallback(cHandle handle);
	bool		RegisterErrorCallback(cHandle* handle, cErrorCallback* callback);
	bool		UnregisterErrorCallback(cHandle handle);

  private:

	// Utility functions
	bool	_DeliverErrorCallback(cObject* obj, unsigned int type);
	bool	_SetupBroadcastSocket(cNetworkLayerParam* param);
	bool	_SetupMulticast(cNetworkLayerParam* param);
	LONG	_GetHostID();
	bool	_SetupNetwork(cNetworkLayerParam* param);
	bool	_ShutdownNetwork();
	bool	_SendDatagram(SOCKET* socket, cIPEndpoint* dest, const char* buffer, const int size);

	// Members
	cHandle			mLayerBelowHandle;
	cRegisterList*	mRegisterList;	
	cRegisterList*  mErrorCallbackList;
	cProtocolStack* mProtocolStack;
	char			mMyEpSer[MAX_ENDPOINT_SIZE];

	// Parameters
	unsigned int mMaxTransferSize;
	unsigned int mMaxHeaderSize;

	// Broadcast stuff
	SOCKET		mBroadcastSocket;
	u_short		mBroadcastPort;
	WSAEVENT	mBroadcastEvent;

	// Multicast Stuff
	SOCKET		mMulticastSocket[MAX_MCAST_INTERFACES];
	WSAEVENT	mMulticastEvent[MAX_MCAST_INTERFACES];
	u_short		mMulticastPort;

	// The local endpoint address
	cIPEndpoint mLocalEndpoint;
};

#endif
